/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.utils.query;

import filenet.vw.api.VWSession;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.VWUsersAndGroupsPanel;
import filenet.vw.toolkit.utils.resources.VWResource;
import filenet.vw.toolkit.utils.table.VWParticipantItem;
import filenet.vw.toolkit.utils.table.VWSortedListModel;
import javax.swing.ListModel;

public class VWAddRemoveUsersPanel
extends VWUsersAndGroupsPanel {
    public VWAddRemoveUsersPanel(VWSession vwSession) {
        super(vwSession, false);
        this.setAvailableItemName(VWResource.s_availableUsers);
        this.setSelectedItemName(VWResource.s_limitUsers);
    }

    public void setSelectedItems(VWParticipantItem[] selectedItems) {
        super.initializeParticipantsLists(selectedItems);
    }

    protected void onAddItemsAction(Object[] items) {
        VWSortedListModel listModel = (VWSortedListModel)this.m_selectedList.getModel();
        for (int i = 0; i < listModel.getSize(); ++i) {
            if (VWStringUtils.compareIgnoreCase(VWResource.s_allUsers, listModel.getElementAt(i).toString()) != 0) continue;
            listModel.removeElementAt(i);
        }
    }

    protected Object[] onRemoveItemsAction(Object[] items) {
        try {
            VWSortedListModel listModel = (VWSortedListModel)this.m_selectedList.getModel();
            if (listModel.size() == 0) {
                listModel.addElement(new VWParticipantItem(VWResource.s_allUsers, 3));
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return items;
    }

    protected void updateTheAllButtonsState() {
        VWSortedListModel listModel = null;
        if (this.m_bShowMoveAllButtons) {
            listModel = (VWSortedListModel)this.m_availableList.getModel();
            this.m_addAllButton.setEnabled(listModel.getSize() > 0);
            listModel = (VWSortedListModel)this.m_selectedList.getModel();
            if (listModel.getSize() > 0) {
                boolean found = false;
                for (int i = 0; i < listModel.size(); ++i) {
                    if (VWStringUtils.compareIgnoreCase(VWResource.s_allUsers, listModel.getElementAt(i).toString()) != 0) continue;
                    found = true;
                    break;
                }
                if (found) {
                    this.m_removeAllButton.setEnabled(false);
                } else {
                    this.m_removeAllButton.setEnabled(true);
                }
            } else {
                this.m_removeAllButton.setEnabled(false);
            }
        }
    }

    protected void updateTheMainButtonsState() {
        int[] selectedIndices = null;
        selectedIndices = this.m_availableList.getSelectedIndices();
        this.m_addButton.setEnabled(selectedIndices.length > 0);
        selectedIndices = this.m_selectedList.getSelectedIndices();
        if (selectedIndices.length > 0) {
            boolean found = false;
            ListModel listModel = this.m_selectedList.getModel();
            for (int i = 0; i < selectedIndices.length; ++i) {
                if (VWStringUtils.compareIgnoreCase(VWResource.s_allUsers, listModel.getElementAt(selectedIndices[i]).toString()) != 0) continue;
                found = true;
                break;
            }
            if (found) {
                this.m_removeButton.setEnabled(false);
            } else {
                this.m_removeButton.setEnabled(true);
            }
        } else {
            this.m_removeButton.setEnabled(false);
        }
        if (this.m_bShowUpDownButtons) {
            if (selectedIndices.length == 0) {
                this.m_moveUpButton.setEnabled(false);
                this.m_moveDownButton.setEnabled(false);
            } else {
                this.m_moveUpButton.setEnabled(selectedIndices[0] != 0);
                ListModel listModel = this.m_selectedList.getModel();
                boolean bEnable = selectedIndices[selectedIndices.length - 1] != listModel.getSize() - 1;
                this.m_moveDownButton.setEnabled(bEnable);
            }
        }
    }
}

